<?php
$subscribeContent = getContent('subscribe.content', true);
?>
<section class="pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="subscribe-wrapper bg_img" data-background="<?php echo e(getImage('assets/images/frontend/subscribe/' . @$subscribeContent->data_values->image, '1920x1281')); ?>">
                    <div class="row align-items-center">
                        <div class="col-lg-5">
                            <h2 class="title"><?php echo e(__(@$subscribeContent->data_values->heading)); ?></h2>
                        </div>
                        <div class="col-lg-7 mt-lg-0 mt-4">
                            <form class="subscribe-form" method="post">
                                <?php echo csrf_field(); ?>
                                <input type="email" class="form-control" name="email" placeholder="<?php echo app('translator')->get('Email Address'); ?>">
                                <button type="submit" class="subscribe-btn"><i class="las la-paper-plane"></i></button>
                            </form>
                        </div>
                    </div>
                </div><!-- subscribe-wrapper end -->
            </div>
        </div>
    </div>
</section>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.subscribe-form').on('submit', function(e) {
                e.preventDefault();
                var data = $('.subscribe-form').serialize();
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('subscribe')); ?>",
                    data: data,
                    success: function(response) {
                        if (response.status == 'success') {
                            notify('success', response.message);
                            $('#email').val('');
                        } else {
                            notify('error', response.message);
                        }
                    }
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u452099573/domains/alpha7x.com/public_html/core/resources/views/templates/bit_gold/sections/subscribe.blade.php ENDPATH**/ ?>